package com.example.demo4.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("异常详情")
public class Anomaly {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键ID",example = "1")
    private Integer id;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "时间",example = "2020-1-1")
    private Date date;

    @ApiModelProperty(value = "图片路径",example = "http://localhost:8083/static/2E6B0C92.png")
    private String images;

    @ApiModelProperty(value = "模块ID",example = "1")
    private Integer titleId;

    @Transient
    @ApiModelProperty(value = "模块名",example = "人员监管")
    private String title;

    @ApiModelProperty(value = "地区ID",example = "1")
    private Integer regionId;

    @Transient
    @ApiModelProperty(value = "地区",example = "杭州")
    private String region;

    @ApiModelProperty(value = "粮仓ID",example = "1")
    private Integer granaryId;

    @Transient
    @ApiModelProperty(value = "粮仓",example = "径山粮仓")
    private String granaryName;

    @ApiModelProperty(value = "区域ID",example = "1")
    private Integer area;

    @Transient
    @ApiModelProperty(value = "区域",example = "A区")
    private String areaName;

    @ApiModelProperty(value = "监管ID",example = "1")
    private Integer action;

    @Transient
    @ApiModelProperty(value = "监管名称",example = "人员入仓")
    private String superviseName;

    @ApiModelProperty(value = "处理方式",example = "劝阻")
    private String processTitle;

    @ApiModelProperty(value = "备注",example = "一段文字")
    private String process;


}
