package com.example.demo4.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Transient;
import java.util.Date;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("显示页面")
public class AnomalyVO {

    @ApiModelProperty(value = "图片路径",example = "http://localhost:8083/static/2E6B0C92.png")
    private String images;

    @Transient
    @ApiModelProperty(value = "粮仓",example = "径山粮仓")
    private String granaryName;

    @Transient
    @ApiModelProperty(value = "区域",example = "A区")
    private String areaName;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern ="yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    @DateTimeFormat(pattern ="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "时间",example = "2020-1-1 00:00:00")
    private Date date;

}
