package com.example.demo4.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

/**
 * @author tykj
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("地区")
public class Details {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键ID",example = "1")
    private Integer id;

    @ApiModelProperty(value = "父键ID",example = "1")
    private Integer regionId;

    @ApiModelProperty(value = "地区名",example = "杭州")
    private String detailsName;

    @Transient
    private List<Details> children;


}
