package com.example.demo4.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;

import javax.persistence.*;
import java.util.List;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("主模块")
public class HomePage {

     @ApiModelProperty(value = "模块ID",example = "1")
     private Integer titleId;

     @ApiModelProperty(value = "模块名",example = "人员监管")
     private String title;

     @ApiModelProperty(value = "今日条数",example = "99")
     private int today;

     @ApiModelProperty(value = "总条数",example = "999")
     private Long quantity;

     @Transient
     private PagePojo anomalyVOList;


}
