package com.example.demo4.controller;

import com.example.demo4.pojo.Anomaly;

import com.example.demo4.pojo.Condition;
import com.example.demo4.pojo.HomePage;
import com.example.demo4.pojo.Supervise;
import com.example.demo4.service.AnomalyService;
import com.example.demo4.service.DetailsService;
import com.example.demo4.service.SuperviseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.util.List;

/**
 * @author tykj
 */
@RestController
@RequestMapping("/model3")
@Api(tags = "粮仓AI智能检测系统",description = "基础接口")
public class Controller {

    @Autowired
    private SuperviseService superviseService;

    @Autowired
    private DetailsService detailsService;

    @Autowired
    private AnomalyService anomalyService;

    @GetMapping("/findSupervise")
    @ApiOperation(value = "根据模块ID查询监管类型")
    public List<Supervise> findSupervise(Integer titleId){
        return superviseService.findSupervise(titleId);
    }

    @PostMapping("/findAll")
    @ApiOperation(value = "动态查询数据")
    public HomePage findAll(Condition condition) throws ParseException {
        return anomalyService.findAll(condition);
    }

    @GetMapping("/findAnomaly")
    @ApiOperation(value = "根据ID查询异常详情")
    public Anomaly findAnomalyId(Integer id){
        return anomalyService.findAnomalyId(id);
    }

    @PostMapping("/saveProcess")
    @ApiOperation(value = "添加处理方式和备注")
    public Anomaly saveProcess(Anomaly anomaly){
        return anomalyService.saveProcess(anomaly);
    }

}
