package com.example.demo4.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Id;
import java.util.Date;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("查询条件")
public class Condition {

    @ApiModelProperty(value = "模块ID",example = "1")
    private Integer titleId;

    @ApiModelProperty(value = "页码",example = "1")
    private Integer page;

    @ApiModelProperty(value = "请求数量",example = "1")
    private Integer pageSize;

    @ApiModelProperty(value = "地区ID",example = "1")
    private Integer regionId;

    @ApiModelProperty(value = "粮仓ID",example = "1")
    private Integer granary;

    @ApiModelProperty(value = "区域ID",example = "1")
    private Integer area;

    @ApiModelProperty(value = "监管ID",example = "1")
    private Integer supervise;


    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern ="yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "开始时间",example = "2020-1-1 00:00:00")
    private Date startDate;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern ="yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间",example = "2020-1-1 00:00:00")
    private Date endDate;


}
