package com.example.demo4.service.imlp;

import com.example.demo4.dao.AnomalyDao;
import com.example.demo4.dao.DetailsDao;
import com.example.demo4.dao.SuperviseDao;
import com.example.demo4.pojo.*;
import com.example.demo4.service.AnomalyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * @author tykj
 */

@Service
@Slf4j
public class AnomalyServiceImpl implements AnomalyService {

    @Autowired
    private AnomalyDao anomalyDao;

    @Autowired
    private DetailsDao detailsDao;

    @Autowired
    private SuperviseDao superviseDao;


    /**
     * 名称转换方法
     * @param anomaly
     * @return
     */
    private Anomaly getAnomaly(Anomaly anomaly){
        //根据地区ID，获取地区名
        String detailsName = detailsDao.findById(anomaly.getRegionId()).get().getDetailsName();
        anomaly.setRegion(detailsName);
        //根据粮仓ID，获取粮仓名
        String detailsName1 = detailsDao.findById(anomaly.getGranaryId()).get().getDetailsName();
        anomaly.setGranaryName(detailsName1);
        //根据区域ID，获取区域名
        String detailsName2 = detailsDao.findById(anomaly.getArea()).get().getDetailsName();
        anomaly.setAreaName(detailsName2);
        //根据监管ID，获取监管名称
        String superviseName = superviseDao.findById(anomaly.getAction()).get().getSuperviseName();
        anomaly.setSuperviseName(superviseName);
        return anomaly;
    }


    @Override
    public Anomaly findAnomalyId(Integer id) {
        log.info("查询id为:{}的异常详情",id);
        Anomaly anomaly = new Anomaly();
        Optional<Anomaly> byId = anomalyDao.findById(id);
        Anomaly anomaly1 = byId.orElse(anomaly);
        return getAnomaly(anomaly1);
    }

    @Override
    public Anomaly saveProcess(Anomaly anomaly) {
        Integer anomalyId = anomaly.getId();
        Anomaly anomalyId1 = findAnomalyId(anomalyId);
        anomaly.setDate(anomalyId1.getDate());
        return getAnomaly(anomalyDao.save(anomaly));
    }

    @Override
    public HomePage findAll(Condition condition) throws ParseException {
        //根据用户传入的参数，进行分页，获取分页后的数据
        Pageable pageable = PageRequest.of(condition.getPage(), condition.getPageSize());

        //动态查询构造器
        Specification<Anomaly> queryCondition = new Specification<Anomaly>() {
            @Override
            public Predicate toPredicate(Root<Anomaly> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicateList = new ArrayList<>();
                if (condition.getTitleId()!=null){
                    predicateList.add(criteriaBuilder.equal(root.get("titleId"), condition.getTitleId()));
                }
                if (condition.getRegionId() != null) {
                    predicateList.add(criteriaBuilder.equal(root.get("regionId"), condition.getRegionId()));
                }
                if (condition.getGranary() != null) {
                    predicateList.add(criteriaBuilder.equal(root.get("granaryId"), condition.getGranary()));
                }
                if (condition.getArea() != null) {
                    predicateList.add(criteriaBuilder.equal(root.get("area"), condition.getArea()));
                }
                if (condition.getSupervise() != null) {
                    predicateList.add(criteriaBuilder.equal(root.get("action"), condition.getSupervise()));
                }
                if (condition.getStartDate() != null) {
                    //使用criteriaBuilder.greaterThan方法，进行比较date，greaterThan大于等于，lessThan小于等于
                    predicateList.add(criteriaBuilder.greaterThan(root.get("date").as(Date.class),condition.getStartDate()));
                }
                if (condition.getEndDate() != null) {
                    predicateList.add(criteriaBuilder.lessThan(root.get("date").as(Date.class),condition.getEndDate()));
                }
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            }
        };

        Page<Anomaly> page = anomalyDao.findAll(queryCondition, pageable);

        List<AnomalyVO> anomalyVoList = new ArrayList<>();
        List<Anomaly> content = page.getContent();

        //循环赋值，把属性注入VO
        for (Anomaly anomaly : content) {

            AnomalyVO anomalyVO = new AnomalyVO();
            BeanUtils.copyProperties(getAnomaly(anomaly),anomalyVO);
            anomalyVoList.add(anomalyVO);
        }
        PagePojo pagePojo = new PagePojo();
        pagePojo.setPage(condition.getPage());
        pagePojo.setPageSize(condition.getPageSize());
        pagePojo.setTotal(page.getTotalElements());
        pagePojo.setAnomalyVOList(anomalyVoList);


        HomePage homePage =new HomePage();
        homePage.setTitleId(condition.getTitleId());
        Optional<Anomaly> byId = anomalyDao.findById(condition.getTitleId());
        Anomaly anomaly = new Anomaly();
        Anomaly anElse = byId.orElse(anomaly);
        homePage.setTitle(anElse.getTitle());

        List<Anomaly> all = anomalyDao.findAll();
        List<Anomaly> o = new ArrayList<>();
        //时间转换，把时间转化为年月日
        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");
        String transformDate=simpleDateFormat.format(new Date());
        Date afterDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(transformDate + " 00:00:00");
        Date endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(transformDate+" 23:59:59");
        for (Anomaly anomaly1 :all){
            //判读时间是否在当日内
              if (anomaly1.getDate().after(afterDate) && anomaly1.getDate().before(endDate)){
                 o.add(anomaly1);
             }
         }
         // 通过page获取数据总条数
         long totalElements = page.getTotalElements();
         homePage.setToday(o.size());
         homePage.setQuantity(totalElements);
         homePage.setAnomalyVOList(pagePojo);

        return homePage;
    }

}
