package com.example.tyweekly.controller;

import com.example.tyweekly.entity.ReturnPojo;
import com.example.tyweekly.entity.WeeklyUser;
import com.example.tyweekly.service.WeeklyUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author tykj
 */
@RestController
@RequestMapping("/ty-weekly/user")
@Api(tags = "周报管理系统",description = "用户信息接口")
@Validated
public class UserController {

    @Autowired
    private WeeklyUserService weeklyUserService;
    @PostMapping("/saveUser")
    @ApiOperation(value = "新增用户")
    public WeeklyUser saveOne(@RequestBody WeeklyUser weeklyUser){
        return weeklyUserService.saveOne(weeklyUser);
    }

    @DeleteMapping("/deleteUser/{id}")
    @ApiOperation(value = "删除用户")
    public ReturnPojo deleteUser(@PathVariable("id")Integer id){
        weeklyUserService.deleteUser(id);
        return ReturnPojo.ok("删除成功");
}











}
