package com.example.tyweekly.dao;

import com.example.tyweekly.entity.WeeklyFile;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import java.util.List;

/**
 * @author tykj
 */
public interface WeeklyFileDao extends JpaRepository<WeeklyFile,Integer>, JpaSpecificationExecutor<WeeklyFile> {

    /**
     * 根据文件名进行模糊查询
     * @param name 文件名
     * @return 实体的集合
     */
    List<WeeklyFile> findAllByWeeklyNameLike(String name);
}
