package com.example.tyweekly.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.validation.constraints.NotNull;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("查询条件")
public class WeeklyCondition {

    @NotNull(message = "页码不能为空")
    @ApiModelProperty(value = "页码",example = "1")
    private Integer page;

    @NotNull(message = "请求数量不能为空")
    @ApiModelProperty(value = "请求数量",example = "1")
    private Integer pageSize;

    @ApiModelProperty(value = "状态",example ="{未上交0 已提交1 全部2}")
    @NotNull(message = "状态不能为空")
    private Integer status;


}
