package com.example.tyweekly.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("后台显示")
public class WeeklyFileVO {

    @ApiModelProperty(value = "用户名称",example = "小明")
    private String userName;

    @ApiModelProperty(value = "文件名字",example = "2022年1月1日xxx")
    private String weeklyName;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "上传时间",example = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime uploadTime;

    @ApiModelProperty(value = "状态",example = "ture")
    private Boolean state;
}
