package com.example.tyweekly.controller;

import com.example.tyweekly.entity.ReturnPojo;
import com.example.tyweekly.entity.WeeklyCondition;
import com.example.tyweekly.service.WeeklyFileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * @author tykj
 */
@RestController
@RequestMapping("/ty-weekly/weekly")
@Api(tags = "周报管理系统",description = "周报信息接口")
@Validated
public class WeeklyController {

    @Autowired
    private WeeklyFileService weeklyFileService;

    @PostMapping("/saveFile")
    @ApiOperation(value = "周报文件上传")
    public ReturnPojo saveFile2(@RequestParam("multipartFile2") MultipartFile multipartFile2){
        try {
            return ReturnPojo.ok(weeklyFileService.uploadDatum(multipartFile2),"上传成功") ;
        } catch (IOException e) {
            e.printStackTrace();
        }return ReturnPojo.error(404,"上传失败");

    }

     @DeleteMapping("/deleteFile/{fileId}")
     @ApiOperation(value = "周报文件删除")
    public ReturnPojo deleteFile(@PathVariable("fileId")Integer fileId){
        weeklyFileService.deleteFile(fileId);
        return ReturnPojo.ok("删除成功");
     }

    @PostMapping("/findAllWeekly")
    @ApiOperation(value = "周报情况动态查询")
    public ResponseEntity findAllWeekly(@RequestBody WeeklyCondition weeklyCondition){
        return ResponseEntity.ok(weeklyFileService.findAllWeekly(weeklyCondition));
    }


    @PostMapping(value = "/download")
    @ApiOperation(value = "一键下载")
    public HttpServletResponse downloadZip(HttpServletResponse response) throws FileNotFoundException {
        return weeklyFileService.downloadZip(response);
    }






}
