package com.example.tyweekly.entity;


import lombok.AllArgsConstructor;
import lombok.Data;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
public class ReturnPojo {


    private Integer code;

    private String message;

    private Object data;

    private ReturnPojo() {  }

    public static ReturnPojo ok(Object data, String message) {
        return new ReturnPojo(200, message,data);
    }


    public static ReturnPojo ok(String data) {
        return ReturnPojo.ok(data, "success");
    }

    public static ReturnPojo error( Integer code, String message) {
        return new ReturnPojo(code, message, "");
    }
}