package com.example.tyweekly.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.time.LocalDateTime;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("周报文件")
public class WeeklyFile {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "文件主键ID",example = "1")
    private Integer id;

    @ApiModelProperty(value = "文件名字",example = "2022年1月1日xxx")
    private String weeklyName;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "上传时间",example = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime uploadTime;

    @ApiModelProperty(value = "文件保存路径",example = "文件地址")
    private String uploadAddress;

}
