package com.example.tyweekly.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author tykj
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("用户")
public class WeeklyUser {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "用户主键ID",example = "1")
    private Integer id;

    @NotNull(message = "用户名不能为空")
    @ApiModelProperty(value = "用户名称",example = "小明")
    private String userName;

    @ApiModelProperty(value = "文件",example = "小明")
    @Transient
    @JsonIgnore
    private List<WeeklyFile> files;

    @ApiModelProperty(value = "单个对象",example = "小明")
    @Transient
    private WeeklyFile fileOne;


}
