package com.example.tyweekly.service;

import com.example.tyweekly.entity.*;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * @author tykj
 */
public interface WeeklyFileService {

    /**
     * 周报上传
     * @param file
     * @return
     * @throws IOException
     */
    WeeklyFile uploadDatum(MultipartFile file) throws IOException;


    /**
     * 删除周报
     * @param id
     * @return
     */
    void deleteFile(Integer id);

    /**
     * 分页查询
     * @param weeklyCondition
     * @return
     */
    Page<WeeklyUser> findAllWeekly(WeeklyCondition weeklyCondition);


    /**
     * 下载
     * @return
     * @throws FileNotFoundException
     */
    HttpServletResponse downloadZip(HttpServletResponse response) throws FileNotFoundException;
}
