package com.example.tyweekly.service.impl;

import com.example.tyweekly.config.PageUtil;
import com.example.tyweekly.config.TimedTask;
import com.example.tyweekly.dao.WeeklyFileDao;
import com.example.tyweekly.dao.WeeklyUserDao;
import com.example.tyweekly.entity.*;
import com.example.tyweekly.service.WeeklyFileService;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author tykj
 */
@Service
@Slf4j
public class WeeklyFileServiceImpl implements WeeklyFileService {

    @Autowired
    private WeeklyFileDao weeklyFileDao;

    @Autowired
    private WeeklyUserDao weeklyUserDao;

    @Value("${file.path}")
    private String download;

    @Value("${file.path1}")
    private String save;

    @Override
    public WeeklyFile uploadDatum(MultipartFile file) throws IOException {
        //MultipartFile 接收前端传过来的文件
        // 注意 前端传参的name要和MultipartFile的对象名保持一直 比如此处对象名为file 则前端传参的name也要为file
        //获取上传文件的文件名
        String oldName = file.getOriginalFilename();
        List<WeeklyFile> all = weeklyFileDao.findAll();
        //删除重名文件
        for (WeeklyFile weeklyFile : all) {
            if (weeklyFile.getWeeklyName().equals(oldName)) {
                weeklyFileDao.deleteById(weeklyFile.getId());
            }
        }
        //指定上传路径
        String path = save;
        //拼接成为新文件的路径
        String filePath = path + oldName;
        //创建新文件对象 指定文件路径为拼接好的路径
        File newFile = new File(filePath);
        //将前端传递过来的文件输送给新文件 这里需要抛出IO异常 throws IOException
        file.transferTo(newFile);
        //上传完成后将文件路径返回给前端用作图片回显或增加时的文件路径值等
        WeeklyFile weeklyFile1 = new WeeklyFile();
        weeklyFile1.setUploadAddress(filePath);
        weeklyFile1.setWeeklyName(oldName);
        weeklyFile1.setUploadTime(LocalDateTime.now());
        return weeklyFileDao.save(weeklyFile1);
    }

    @Override
    public void deleteFile(Integer id) {
        String fileUpload = weeklyFileDao.findById(id).get().getUploadAddress();
        File file = new File(fileUpload);
        file.delete();
        weeklyFileDao.deleteById(id);
    }

    @Override
    public Page<WeeklyUser> findAllWeekly(WeeklyCondition weeklyCondition) {
        //根据传入的数据，进行分页数据查询
        Pageable of1 = PageRequest.of(weeklyCondition.getPage()-1, weeklyCondition.getPageSize());
        Map<String, WeeklyUser> userMap = weeklyUserDao.findAll().stream().collect(Collectors.toMap(WeeklyUser::getUserName, Function.identity()));
        List<String> userNames = new ArrayList<>(userMap.keySet());
        //动态查询构造器
        List<WeeklyFile> weeklyFileList = weeklyFileDao.findAll();
        List<WeeklyUser> userList = new ArrayList<>();
        int a = 0;
        //查询已上交
        userNames.forEach(s -> {
            WeeklyUser weeklyUser = userMap.get(s);
            List<WeeklyFile> weeklyFiles = new ArrayList<>();
            weeklyFileList.forEach(weeklyFile -> {
                if (weeklyFile.getWeeklyName().contains(s)) {
                    //如果存在
                    weeklyFiles.add(weeklyFile);
                }
            });
            weeklyUser.setFiles(weeklyFiles);
            userList.add(weeklyUser);
        });
        //做处理
        //1 上交的
        Integer status = weeklyCondition.getStatus();
        List<WeeklyUser> userList1 = new ArrayList<>();
        switch (status) {
            case 0:
                //未上交
                userList1 = userList.stream().filter(weeklyUser -> weeklyUser.getFiles().size() == 0).collect(Collectors.toList());
                break; //可选
            case 1:
                //提交
                userList1 = userList.stream().filter(weeklyUser -> weeklyUser.getFiles().size() != 0).collect(Collectors.toList());
                break; //可选
            //你可以有任意数量的case语句
            case 2:
                //提交
                userList1 = userList;
                break; //可选
            default: //可选
                userList1 = userList;
                //userList
        }
        for (WeeklyUser weeklyUser : userList1) {
            if (weeklyUser.getFiles().size() == 0) {
                weeklyUser.setFiles(null);
            } else {
                for (WeeklyFile file : weeklyUser.getFiles()) {
                    weeklyUser.setFileOne(file);
                }
            }
        }
        //做物理分页
        Page<WeeklyUser> perPage = PageUtil.getPerPage(of1.getPageNumber(), of1.getPageSize(), userList1, of1);
        long totalElements = perPage.getTotalElements();
        return perPage;
    }

    @Override

    public HttpServletResponse downloadZip(HttpServletResponse response) throws FileNotFoundException {

        List<WeeklyFile> all = weeklyFileDao.findAll();
        List<File> fileList = new ArrayList<>();
        for (WeeklyFile weeklyFile : all) {
            fileList.add(new File(weeklyFile.getUploadAddress()));
        }
        FileOutputStream fos2 = new FileOutputStream(download);
        TimedTask.toZip(fileList,fos2);
        try {
            File file = new File(download);
            // 取得文件名。
            String filename = file.getName();
            // 取得文件的后缀名。
            String ext = filename.substring(filename.lastIndexOf(".") + 1).toUpperCase();
            // 以流的形式下载文件。
            InputStream fis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();
            // 设置response的Header
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes()));
            response.addHeader("Content-Length", "" + file.length());
            OutputStream toClient = new BufferedOutputStream(response.getOutputStream());
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("application/octet-stream; charset=utf-8");
            toClient.write(buffer);
            toClient.flush();
            toClient.close();

        } catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }


}
