package com.yl.synchronization.config;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;


/**
 * @author zjm
 */
@ComponentScan
@Configuration
@Slf4j
public class DataSourceConfig {


    /**
     * A数据源
     * @return
     */

    @Primary
    @Bean(name = "remoteDataSource0")
    @Qualifier("remoteDataSource0")
    @ConfigurationProperties(prefix="spring.datasource.remote0")
    public DataSource secondaryDataSource0() {
        log.info("A数据源创建中————");
        return DruidDataSourceBuilder.create()
                .build();
    }

    /**
     * B数据源
     *
     */
    @Bean(name = "remoteDataSource1")
    @Qualifier("remoteDataSource1")
    @ConfigurationProperties(prefix="spring.datasource.remote1")
    public DataSource secondaryDataSource1() {
        log.info("B数据源创建中————");
        return DruidDataSourceBuilder.create()
                .build();
    }





}
