package com.yl.synchronization.bean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * entity class for volunteer_applys
*/
@Data
@Entity
@ApiModel("志愿者")
@Table(name = "share_yl_volunteer_applys",schema = "volunteer_applys")
public class VolunteerApply {

	/**
	* id
	*/
	@Id
	@Column(name = "id")
	@ApiModelProperty(name = "id")
	private Long id;
	/**
	* 用户id
	*/
	@Column(name = "user_id")
	@ApiModelProperty(name = "用户id")
	private Integer userId;
	/**
	* 手机号
	*/
	@Column(name = "phone")
	@ApiModelProperty(name = "手机号")
	private String phone;
	/**
	* 姓名
	*/
	@Column(name = "name")
	@ApiModelProperty(name = "姓名")
	private String name;
	/**
	* 姓名
	*/
	@Column(name = "id_card")
	@ApiModelProperty(name = "姓名")
	private String idCard;
	/**
	* 所在区
	*/
	@Column(name = "area")
	@ApiModelProperty(name = "所在区")
	private String area;
	/**
	* 男 女
	*/
	@Column(name = "gender")
	@ApiModelProperty(name = "男 女")
	private String gender;
	/**
	* 面貌
	*/
	@Column(name = "face")
	@ApiModelProperty(name = "面貌")
	private Integer face;
	/**
	* 民族
	*/
	@Column(name = "nation")
	@ApiModelProperty(name = "民族")
	private String nation;
	/**
	* 学历
	*/
	@Column(name = "edu")
	@ApiModelProperty(name = "学历")
	private String edu;
	/**
	* 职称
	*/
	@Column(name = "job_title")
	@ApiModelProperty(name = "职称")
	private String jobTitle;
	/**
	* 从业类别
	*/
	@Column(name = "work_type")
	@ApiModelProperty(name = "从业类别")
	private Integer workType;
	/**
	* 所在单位
	*/
	@Column(name = "work")
	@ApiModelProperty(name = "所在单位")
	private String work;
	/**
	* 服务类别
	*/
	@Column(name = "service_type")
	@ApiModelProperty(name = "服务类别")
	private String serviceType;
	/**
	* 服务领域
	*/
	@Column(name = "service_domain")
	@ApiModelProperty(name = "服务领域")
	private String serviceDomain;
	/**
	* 是否有志愿经验1是0没有
	*/
	@Column(name = "is_exp")
	@ApiModelProperty(name = "是否有志愿经验1是0没有")
	private String isExp;
	/**
	* 志愿经验
	*/
	@Column(name = "exp")
	@ApiModelProperty(name = "志愿经验")
	private String exp;
	/**
	* 状态1待操作 2通过 3拒绝
	*/
	@Column(name = "status")
	@ApiModelProperty(name = "状态1待操作 2通过 3拒绝")
	private Boolean status;
	/**
	* createdAt
	*/
	@Column(name = "created_at")
	@ApiModelProperty(name = "null")
	private Date createdAt;
	/**
	* updatedAt
	*/
	@Column(name = "updated_at")
	@ApiModelProperty(name = "null")
	private Date updatedAt;
	/**
	* 所属网点
	*/
	@Column(name = "branch_id")
	@ApiModelProperty(name = "所属网点")
	private Long branchId;

	/**
	 * 状态 1：正常 0：已删除
	 */
	@Column(name = "DATA_ACTIVE_STATUS")
	@ApiModelProperty(name = "状态 1：正常 0：已删除")
	private String dataActiveStatus;

}
