package com.yl.synchronization.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.Map;

/**
 * @author zjm
 */
@SuppressWarnings("ALL")
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryRemote0",
        transactionManagerRef = "transactionManagerRemote0",
        basePackages = {"com.yl.synchronization.repository"
                        }
)
@EnableConfigurationProperties(JpaProperties.class)
public class RemoteConfig0 {

    @Autowired
    @Qualifier("remoteDataSource0")
    private DataSource remoteDataSource;

    @Autowired
    private HibernateProperties properties;

    @Primary
    @Bean(name = "entityManagerRemote0")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryRemote1(builder).getObject().createEntityManager();
    }

    @Primary
    @Bean(name = "entityManagerFactoryRemote0")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryRemote1(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(remoteDataSource)
                .properties(properties.determineHibernateProperties(jpaProperties.getProperties(), new
                        HibernateSettings()))
                .packages(
                        "com.yl.synchronization.bean")
                .persistenceUnit("remotePersistenceUnit0")
                .build();
    }

    @Autowired
    private JpaProperties jpaProperties;


    private Map<String, String> getVendorProperties() {
        return jpaProperties.getProperties();
    }


    @Primary
    @Bean(name = "transactionManagerRemote0")
    public PlatformTransactionManager transactionManagerRemote(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryRemote1(builder).getObject());
    }
}
