package com.yl.synchronization.oldBean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.util.Date;

/**
 * @author zxx
 * @date 2023/4/21 17:52
 */
@Data
@Entity
@ApiModel("活动保存")
public class OldActivity {
    /**
     * id
     */
    @Id
    @Column(name = "id")
    @ApiModelProperty(name = "id")
    private Long id;
    /**
     * 活动标题
     */
    @Column(name = "title")
    @ApiModelProperty(name = "活动标题")
    private String title;
    /**
     * 封面
     */
    @Column(name = "cover")
    @ApiModelProperty(name = "封面")
    private String cover;
    /**
     * 活动编码
     */
    @Column(name = "code")
    @ApiModelProperty(name = "活动编码")
    private String code;
    /**
     * 活动类型 1线上2线下
     */
    @Column(name = "type")
    @ApiModelProperty(name = "活动类型 1线上2线下")
    private String type;
    /**
     * 活动区域
     */
    @Column(name = "area")
    @ApiModelProperty(name = "活动区域")
    private String area;
    /**
     * 详细地点
     */
    @Column(name = "address")
    @ApiModelProperty(name = "详细地点")
    private String address;
    /**
     * 服务类别...
     */
    @Column(name = "service_type")
    @ApiModelProperty(name = "服务类别...")
    private String serviceType;
    /**
     * 服务对象
     */
    @Column(name = "service_obj")
    @ApiModelProperty(name = "服务对象")
    private String serviceObj;
    /**
     * 关联项目
     */
    @Column(name = "project")
    @ApiModelProperty(name = "关联项目")
    private String project;
    /**
     * 主办单位
     */
    @Column(name = "organizer")
    @ApiModelProperty(name = "主办单位")
    private String organizer;
    /**
     * 承办单位
     */
    @Column(name = "contractor")
    @ApiModelProperty(name = "承办单位")
    private String contractor;
    /**
     * 协办单位
     */
    @Column(name = "sponsor")
    @ApiModelProperty(name = "协办单位")
    private String sponsor;
    /**
     * 发布时间
     */
    @Column(name = "release_time")
    @ApiModelProperty(name = "发布时间")
    private Date releaseTime;
    /**
     * 招募时间
     */
    @Column(name = "recruit_time")
    @ApiModelProperty(name = "招募时间")
    private Date recruitTime;
    /**
     * 招募人数
     */
    @Column(name = "recruit_number")
    @ApiModelProperty(name = "招募人数")
    private Integer recruitNumber;
    /**
     * 活动时间
     */
    @Column(name = "activity_time")
    @ApiModelProperty(name = "活动时间")
    private Date activityTime;
    /**
     * 活动结束时间
     */
    @Column(name = "activity_time_end")
    @ApiModelProperty(name = "活动结束时间")
    private Date activityTimeEnd;
    /**
     * 活动简介
     */
    @Column(name = "introduction")
    @ApiModelProperty(name = "活动简介")

    private String introduction;
    /**
     * 活动要求
     */
    @Column(name = "claim")
    @ApiModelProperty(name = "活动要求")
    private String claim;
    /**
     * 所属组织
     */
    @Column(name = "adscription_org")
    @ApiModelProperty(name = "所属组织")
    private String adscriptionOrg;
    /**
     * 联系人
     */
    @Column(name = "contact_person")
    @ApiModelProperty(name = "联系人")
    private String contactPerson;
    /**
     * 联系电话
     */
    @Column(name = "contact_phone")
    @ApiModelProperty(name = "联系电话")
    private String contactPhone;
    /**
     * 联系邮箱
     */
    @Column(name = "contact_email")
    @ApiModelProperty(name = "联系邮箱")
    private String contactEmail;
    /**
     * 网点id
     */
    @Column(name = "branch_id")
    @ApiModelProperty(name = "网点id")
    private Long branchId;
    /**
     * 是否签到
     */
    @Column(name = "is_sign")
    @ApiModelProperty(name = "是否签到")
    private Boolean isSign;
    /**
     * 签到精度/单位米
     */
    @Column(name = "sign_precision")
    @ApiModelProperty(name = "签到精度/单位米")
    private Integer signPrecision;
    /**
     * 活动状态
     */
    @Column(name = "status")
    @ApiModelProperty(name = "活动状态")
    private Integer status;
    /**
     * 纬度
     */
    @Column(name = "latitude")
    @ApiModelProperty(name = "纬度")
    private String latitude;
    /**
     * 经度
     */
    @Column(name = "longitude")
    @ApiModelProperty(name = "经度")
    private String longitude;
    /**
     * 人数限制0不限制
     */
    @Column(name = "people_number")
    @ApiModelProperty(name = "人数限制0不限制")
    private Integer peopleNumber;
    /**
     * createdAt
     */
    @Column(name = "created_at")
    @ApiModelProperty(name = "null")
    private Date createdAt;
    /**
     * updatedAt
     */
    @Column(name = "updated_at")
    @ApiModelProperty(name = "null")
    private Date updatedAt;
    /**
     * 发布管理员
     */
    @Column(name = "admin_id")
    @ApiModelProperty(name = "发布管理员")
    private Integer adminId;
    /**
     * 状态 1：正常 0：已删除
     */
    @Column(name = "DATA_ACTIVE_STATUS")
    @ApiModelProperty(name = "状态 1：正常 0：已删除")
    private String dataActiveStatus;

}
