package com.yl.synchronization.oldBean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.Date;

/**
 * @author zxx
 * @date 2023/4/21 17:52
 */
@Data
@Entity
@ApiModel("网点保存")
public class OldBranches {

    /**
     * id
     */
    @Id
    @Column(name = "id")
    @ApiModelProperty(name = "id")
    private Long id;
    /**
     * 关联的平台用户
     */
    @Column(name = "uid")
    @ApiModelProperty(name = "关联的平台用户")
    private Integer uid;
    /**
     * 申请的网点名
     */
    @Column(name = "name")
    @ApiModelProperty(name = "申请的网点名")
    private String name;
    /**
     * 网点地址
     */
    @Column(name = "address")
    @ApiModelProperty(name = "网点地址")
    private String address;
    /**
     * 联系人
     */
    @Column(name = "contact_person")
    @ApiModelProperty(name = "联系人")
    private String contactPerson;
    /**
     * 联系电话
     */
    @Column(name = "contact_phone")
    @ApiModelProperty(name = "联系电话")
    private String contactPhone;
//	/**
//	* 单位类型1中国科协2全国学会3地方科协
//	*/
//	@Column(name = "unit_type")
//	@ApiModelProperty(name = "单位类型1中国科协2全国学会3地方科协")
//	private Boolean unitType;

    /**
     * 单位类型1中国科协2全国学会3地方科协
     */
    @Column(name = "unit_type")
    @ApiModelProperty(name = "单位类型1中国科协2全国学会3地方科协")
    private Integer unitType;
    /**
     * 单位名称
     */
    @Column(name = "unit_name")
    @ApiModelProperty(name = "单位名称")
    private String unitName;
    /**
     * 容量
     */
    @Column(name = "capacity")
    @ApiModelProperty(name = "容量")
    private String capacity;
    /**
     * createdAt
     */
    @Column(name = "created_at")
    @ApiModelProperty(name = "null")
    private Date createdAt;
    /**
     * updatedAt
     */
    @Column(name = "updated_at")
    @ApiModelProperty(name = "null")
    private Date updatedAt;
    /**
     * 封面
     */
    @Column(name = "cover")
    @ApiModelProperty(name = "封面")
    private String cover;
    /**
     * 纬度
     */
    @Column(name = "latitude")
    @ApiModelProperty(name = "纬度")
    private String latitude;
    /**
     * 经度
     */
    @Column(name = "longitude")
    @ApiModelProperty(name = "经度")
    private String longitude;
    /**
     * 街道
     */
    @Column(name = "street")
    @ApiModelProperty(name = "街道")
    private String street;
    /**
     * 所在区330101
     */
    @Column(name = "area")
    @ApiModelProperty(name = "所在区330101")
    private String area;
    /**
     * 队长姓名
     */
    @Column(name = "leader_name")
    @ApiModelProperty(name = "队长姓名")
    private String leaderName;
    /**
     * 队长电话
     */
    @Column(name = "leader_phone")
    @ApiModelProperty(name = "队长电话")
    private String leaderPhone;
    /**
     * 成立日期
     */
    @Column(name = "found_date")
    @ApiModelProperty(name = "成立日期")
    private Date foundDate;
    /**
     * 网点详细地址
     */
    @Column(name = "full_address")
    @ApiModelProperty(name = "网点详细地址")
    private String fullAddress;

    @Transient
    @Column(name = "activityApplyNum")
    @ApiModelProperty(name = "培训人数")
    private Long activityApplyNum;

    /**
     * 状态 1：正常 0：已删除
     */
    @Column(name = "DATA_ACTIVE_STATUS")
    @ApiModelProperty(name = "状态 1：正常 0：已删除")
    private String dataActiveStatus;
}
