package com.yl.synchronization.task;

import com.yl.synchronization.bean.Activity;
import com.yl.synchronization.oldBean.OldActivity;
import com.yl.synchronization.oldRepository.OldActivityDao;
import com.yl.synchronization.oldRepository.OldBranchesDao;
import com.yl.synchronization.oldRepository.OldTextbookDao;
import com.yl.synchronization.oldRepository.OldVolunteerApplyDao;
import com.yl.synchronization.repository.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 定时同步数据
 * @author zxx
 * @date 2023/4/21 17:19
 */
@Slf4j
@Component
@EnableScheduling
public class OrgCache {

    @Autowired
    private ActivityDao activityDao;

    @Autowired
    private BranchesDao branchesDao;

    @Autowired
    private TextbookDao textbookDao;

    @Autowired
    private VolunteerApplyDao volunteerApplyDao;

    @Autowired
    private OldActivityDao oldActivityDao;

    @Autowired
    private OldBranchesDao oldBranchesDao;

    @Autowired
    private OldTextbookDao oldTextbookDao;

    @Autowired
    private OldVolunteerApplyDao oldVolunteerApplyDao;


    @Scheduled(initialDelay = 1000, fixedRate = 3600 * 1000)
    public void updateActivityData() {
        log.info("活动数据同步中————");
        //创建新的活动集合
        List<Activity> activities = activityDao.findAll();
        //旧的活动集合
        List<OldActivity> oldActivities = oldActivityDao.findAll();
        for (Activity activity : activities) {
            for (OldActivity oldActivity : oldActivities) {
                //判断id主键是否相同
                assert activity != null;
                if (activity.getId().equals(oldActivity.getId())) {
                    //判断更新时间是否相同
                    if (activity.getUpdatedAt() != oldActivity.getUpdatedAt()) {
                        //复制
                        BeanUtils.copyProperties(activity, oldActivity);
                        //更新保存
                        oldActivityDao.save(oldActivity);
                    }
                    //如果相同则设置为null
                    activity = null;
                    oldActivity = null;
                }
                //判断是否需要删除
                if (oldActivity != null) {
                    oldActivityDao.deleteById(oldActivity.getId());
                }
            }
            //判断是否新增
            if (activity != null) {
                OldActivity oldActivity = new OldActivity();
                //复制
                BeanUtils.copyProperties(activity, oldActivity);
                oldActivityDao.save(oldActivity);
            }
        }
        log.info("活动数据同步结束————");
    }

}
