package com.zjty.tynotes.attendance.service.impl;

import com.zjty.tynotes.attendance.dao.AttendanceDetailsDao;
import com.zjty.tynotes.attendance.entity.AttendanceDetails;
import com.zjty.tynotes.attendance.entity.vo.UserAttenVo;
import com.zjty.tynotes.attendance.entity.vo.request.AttenRequest;
import com.zjty.tynotes.attendance.service.AttendanceDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/24 14:56
 */
@Service
public class AttendanceDetailsServiceImpl implements AttendanceDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(AttendanceDetailsServiceImpl.class);

    @Autowired
    private AttendanceDetailsDao attendanceDetailsDao;

    @Override
    public UserAttenVo findPersonnel(AttenRequest request) {
        UserAttenVo userAttenVo = new UserAttenVo();
        SimpleDateFormat sdf = null;
        String searchType = request.getSearchType();
        if(("0").equals(searchType)){
            sdf = new SimpleDateFormat("yyyy-MM");
            String format = sdf.format(request.getDate());
            try {
                Date parse = sdf.parse(format);
                AttendanceDetails attendanceDetails = attendanceDetailsDao.findByUserIdAndDate(request.getId(), parse);
                userAttenVo = (UserAttenVo) attendanceDetails;
                userAttenVo.setName("");
                return userAttenVo;
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }else{
            sdf = new SimpleDateFormat("yyyy");
            String format = sdf.format(request.getDate());

            Date endDate = null;
            try {
                Date startDate = sdf.parse(format + "-01");
                endDate = sdf.parse(format + "-12");
                List<AttendanceDetails> attendanceDetails = attendanceDetailsDao.findAllByUserIdAndDateBetween(request.getId(), startDate, endDate);
                userAttenVo.setUserId(request.getId());
                int averageWorkHours = 0;
                int attendanceDay = 0;
                int realAttendanceDay = 0;
                int lateDay = 0;
                int leaveEarlyDay = 0;
                int lessCard = 0;
                int absenteeismDay = 0;
                int workOverHours = 0;
                float paidLeaveDay = 0;
                float sickLeaveDay = 0;
                float outSideBusinessDay = 0;
                for (AttendanceDetails attendanceDetails1 : attendanceDetails) {
//                    averageWorkHours += attendanceDetails1.getAverageWorkHours();
//                    attendanceDay += attendanceDetails1.getAttendanceDay();
//                    realAttendanceDay += attendanceDetails1.getRealAttendanceDay();
//                    lateDay += attendanceDetails1.getLateDay();
//                    leaveEarlyDay += attendanceDetails1.getLeaveEarlyDay();
//                    lessCard += attendanceDetails1.getLessCard();
//                    absenteeismDay += attendanceDetails1.getAbsenteeismDay();
//                    workOverHours += attendanceDetails1.getWorkOverHours();
//                    paidLeaveDay += attendanceDetails1.getPaidLeaveDay();
//                    sickLeaveDay += attendanceDetails1.getSickLeaveDay();
//                    outSideBusinessDay += attendanceDetails1.getOutSideBusinessDay();
                }
//                userAttenVo.setAverageWorkHours(averageWorkHours);
//                userAttenVo.setAttendanceDay(attendanceDay);
//                userAttenVo.setRealAttendanceDay(realAttendanceDay);
//                userAttenVo.setLateDay(lateDay);
//                userAttenVo.setLeaveEarlyDay(leaveEarlyDay);
//                userAttenVo.setLessCard(lessCard);
//                userAttenVo.setAbsenteeismDay(absenteeismDay);
//                userAttenVo.setWorkOverHours(workOverHours);
//                userAttenVo.setPaidLeaveDay(paidLeaveDay);
//                userAttenVo.setSickLeaveDay(sickLeaveDay);
//                userAttenVo.setOutSideBusinessDay(outSideBusinessDay);
                userAttenVo.setName("");
                return userAttenVo;
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Object findDepartment(AttenRequest request) {
        return null;
    }
}
