package com.zjty.tynotes.job.basic.entity.database;

import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@AllArgsConstructor
@AutoDocument
@NoArgsConstructor
@ApiModel(value = "评分", description = "评分对象")
public class ScoreCoefficient {
    /**
     * 编号
     */
    @ApiModelProperty(value = "编号", example = "id")
    private String id;

    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务id", example = "任务id")
    private String wordId;

    /**
     * 自评分
     */
    @ApiModelProperty(value = "自评分", example = "score1")
    private String score1;

    /**
     * 组长评分
     */
    @ApiModelProperty(value = "组长评分", example = "groupLeaderScore2")
    private String  groupLeaderScore2;
    /**
     * 总监评分
     */
    @ApiModelProperty(value = "总监评分", example = "directorScore2")
    private String directorScore2;
    /**
     * 副总经理评分
     */
    @ApiModelProperty(value = "副总经理评分", example = "viceScore2")
    private String viceScore3;

    /**
     * 总经理评分
     */
    @ApiModelProperty(value = "正总经理评分", example = "justScore4")
    private String justScore4;
    /**
     *  最终工作量
     */
    @ApiModelProperty(value = "最终工作量", example = "endWorkLoad")
    private Double endWorkLoad;

    /**
     * 考评的时间  每个阶段考评的时间 后一个阶段考评了 覆盖这个时间
     */
    private Date time;

    public ScoreCoefficient(String id, String wordId, String score1, String groupLeaderScore2, String directorScore2, String viceScore3, String justScore4, Double endWorkLoad) {
        this.id = id;
        this.wordId = wordId;
        this.score1 = score1;
        this.groupLeaderScore2 = groupLeaderScore2;
        this.directorScore2 = directorScore2;
        this.viceScore3 = viceScore3;
        this.justScore4 = justScore4;
        this.endWorkLoad = endWorkLoad;
    }
}
