package com.zjty.tynotes.job.task;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.repository.ScoreCoefficientRepository;
import com.zjty.tynotes.job.basic.service.ScoreCoefficientService;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.job.common.Action;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.status.service.BusinessTreeManagement;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;

@Slf4j
@Service
public class Task {
    @Autowired
    ScoreCoefficientRepository scoreCoefficientRepository;
    @Autowired
    WorkService workService;
    @Autowired
    BusinessTreeManagement businessTreeManagement;

    @Scheduled(cron ="0 0 0 * * ?")
    public void task() {

        long time=LocalDateTime.now().minusDays(1)
                .withHour(0)
                .withMinute(0)
                .withSecond(0)
                .withNano(0)
                .atOffset(ZoneOffset.ofHours(8))
                .toEpochSecond();


        long finalTime2 = time;
        scoreCoefficientRepository.findAllByGroupLeaderScore2IsNullOrDirectorScore2IsNull()
                               .forEach(
                                       sc->{
                                          Work work=workService.findById(sc.getWordId());
                                          if (sc.getTime().getTime()< finalTime2){
                                            if(sc.getDirectorScore2()==null&&sc.getGroupLeaderScore2() != null){
                                                sc.setDirectorScore2(sc.getGroupLeaderScore2());
                                                sc.setTime(new Date());
                                                businessTreeManagement.saveAction(work.getMajordomos().get(0),sc.getWordId(),Action.APPRAISAL_WORD,new Date(),"总监评价");
                                            }else if (sc.getGroupLeaderScore2()==null && sc.getDirectorScore2() !=null){
                                                sc.setGroupLeaderScore2(sc.getDirectorScore2());
                                                sc.setTime(new Date());
                                                businessTreeManagement.saveAction(work.getAudit(),sc.getWordId(),Action.APPRAISAL_WORD,new Date(),"组长评价");
                                            }else {
                                                sc.setTime(new Date());
                                                sc.setGroupLeaderScore2(sc.getScore1());
                                                businessTreeManagement.saveAction(work.getAudit(),sc.getWordId(),Action.APPRAISAL_WORD,new Date(),"组长评价");
                                                sc.setDirectorScore2(sc.getScore1());
                                                businessTreeManagement.saveAction(work.getMajordomos().get(0),sc.getWordId(),Action.APPRAISAL_WORD,new Date(),"总监评价");
                                            }
                                              scoreCoefficientRepository.save(sc);
//                                              workService.alterTaskStatus(sc.getWordId(),WorkStatus.FINISHED,work.getPublisher());
//                                              businessTreeManagement.saveAction(work.getPublisher(), sc.getWordId(), Action.FINISHED_WORK, new Date(), "");
                                          }

                                       }
                               );

        time=LocalDateTime.now().minusDays(2)
                .withHour(0)
                .withMinute(0)
                .withSecond(0)
                .withNano(0)
                .atOffset(ZoneOffset.ofHours(8))
                .toEpochSecond();
        //副总经理
        long finalTime1 = time;
        scoreCoefficientRepository.findAllByGroupLeaderScore2IsNotNullAndDirectorScore2IsNotNullAndViceScore3IsNull()
                .forEach(
                        sc->{
                            Work work=workService.findById(sc.getWordId());
                            if (sc.getTime().getTime()< finalTime1){
                                    String score3= String.valueOf(Integer.valueOf(sc.getDirectorScore2())+Integer.valueOf(sc.getGroupLeaderScore2()));
                                    sc.setViceScore3(score3);
                                    sc.setTime(new Date());
                                    businessTreeManagement.saveAction(work.getAssistantManagers().get(0),sc.getWordId(),Action.APPRAISAL_WORD,new Date(),"副总经理评价");
                                }
                                scoreCoefficientRepository.save(sc);
//                                              workService.alterTaskStatus(sc.getWordId(),WorkStatus.FINISHED,work.getPublisher());
//                                              businessTreeManagement.saveAction(work.getPublisher(), sc.getWordId(), Action.FINISHED_WORK, new Date(), "");
                            }


                );

        time=LocalDateTime.now().minusDays(2)
                .withHour(0)
                .withMinute(0)
                .withSecond(0)
                .withNano(0)
                .atOffset(ZoneOffset.ofHours(8))
                .toEpochSecond();
        //总经理
        long finalTime = time;
        scoreCoefficientRepository.findAllByViceScore3IsNotNullAndJustScore4IsNull()
                .forEach(
                        sc->{
                            Work work=workService.findById(sc.getWordId());
                            if (sc.getTime().getTime()< finalTime){
                                sc.setJustScore4(sc.getViceScore3());
                                sc.setTime(new Date());
                                businessTreeManagement.saveAction(work.getGeneralManagers().get(0),sc.getWordId(),Action.APPRAISAL_WORD,new Date(),"总经理评价");
                            }
                            scoreCoefficientRepository.save(sc);
                            workService.alterTaskStatus(sc.getWordId(),WorkStatus.FINISHED,work.getPublisher());
                            businessTreeManagement.saveAction(work.getGeneralManagers().get(0), sc.getWordId(), Action.FINISHED_WORK, new Date(), "");
                        }


                );
    }
}
