package com.zjty.tynotes.attendance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotEmpty;

/**
 * @Author gwj
 * @create 2020/4/13 8:47
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "用户迟到次数", description = "用户迟到次数")
@Document(collection = "user_late")
public class UserLateNum {

    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotEmpty(message = "用户id")
    @ApiModelProperty(value = "用户id",example = "eqsd12314rrqsad1233")
    private String userId;

    @ApiModelProperty(value = "时间，某年某月，格式2020-04",example = "2020-04")
    private String date;

    @ApiModelProperty(value = "迟到次数",example = "5")
    private Integer lateNum;

}
