package com.zjty.tynotes.attendance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @Author gwj
 * @create 2020/3/25 10:22
 * @des 员工加班时长
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "员工加班时长", description = "员工加班时长")
@Document(collection = "ding_useroverwork")
public class UserOverWork {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String userId;

    @ApiModelProperty(value = "加班时长",example = "2")
    private Long overWorkHour;

}
