package com.zjty.tynotes.attendance.service.impl;

import com.zjty.tynotes.attendance.dao.DingUserDao;
import com.zjty.tynotes.attendance.entity.DingUser;
import com.zjty.tynotes.attendance.service.DingUserService;
import com.zjty.tynotes.attendance.task.MyInit;
import com.zjty.tynotes.pas.dao.PasUserDao;
import com.zjty.tynotes.pas.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/24 13:48
 */
@Service
public class DingUserServiceImpl implements DingUserService {

    @Autowired
    private PasUserDao pasUserDao;
    @Autowired
    private DingUserDao dingUserDao;
    @Autowired
    private MyInit init;

    /**
     * 获取钉钉用户与本地用户的所有对应关系
     */
    @Override
    public void initDingUser(){
        init.userIds.clear();
        init.dingUserList.clear();
        init.getUserList();
        List<User> users = pasUserDao.findAll();
        List<DingUser> dingUsers = dingUserDao.findAll();
        for (String dingsuerId : init.userIds) {
            init.getUserDetails(dingsuerId,users,dingUsers);
        }
        dingUserDao.saveAll(init.dingUserList);
    }
}
