package com.zjty.tynotes.job.basic.service.impl;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.entity.database.WorkTime;
import com.zjty.tynotes.job.basic.repository.WorkTimeRepository;
import com.zjty.tynotes.job.basic.service.WorkTimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
@Service
public class WorkTimeServiceImpl implements WorkTimeService {

    @Autowired
    WorkTimeRepository workTimeRepository;

    @Override
    public void saveWorkStartTime(Work work, Date startTime) {
      List<WorkTime> works= workTimeRepository.findByWorkId(work.getId());

      if (works!=null && works.size()!=0){
          for (WorkTime workTime:works){
                if (workTime.getCount()==works.size()){
                    workTime.setEndTime(startTime);
                    workTimeRepository.save(workTime);
                }
          }
      }else {
          workTimeRepository.save(new WorkTime(null,work.getId(),1,work.getStateTime(),startTime));

      }

    }

    @Override
    public void saveWorkEndTime(Work work, Date endTime) {
        List<WorkTime> works= workTimeRepository.findByWorkId(work.getId());
        if (works!=null){
            workTimeRepository.save(new WorkTime(null,work.getId(),works.size()+1,endTime,null));
        }
    }

    @Override
    public List<WorkTime> selectWorkTime(String workId) {

        return workTimeRepository.findByWorkId(workId);
    }
}
