package com.zjty.tynotes.job.common.exception;

import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * <p>Description : ty-note-backend
 * <p>Date : 2019/4/28 11:08
 * <p>@author : C
 */
@Slf4j
@RestControllerAdvice
public class JobExceptionHandle {

    @ExceptionHandler(value = BadRequestException.class)
    public ResponseEntity noteBadRequestExceptionHandler(Exception e) {
        log.error("[note] 出现异常");
        return new ResponseEntity<>(
                ImmutableMap.of("message", e.getMessage()),
                HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value = NotFoundException.class)
    public ResponseEntity noteNotFoundExceptionHandler(Exception e) {
        log.error("[note] 出现异常");
        return new ResponseEntity<>(
                ImmutableMap.of("message", e.getMessage()),
                HttpStatus.NOT_FOUND);
    }

}
