package com.zjty.tynotes.job.status.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * @author LJJ cnljj1995@gmail.com
 * on 2019-05-13
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "操作历史对象", description = "操作历史的一条记录")
public class ActionHistory {

    @ApiModelProperty(value = "任务id", name = "taskId", example = "qwer1234")
    private String taskId;

    @ApiModelProperty(value = "操作日期", name = "date", example = "2018-01-01 12:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date date;

    @ApiModelProperty(value = "备注", name = "msg", example = "这是备注信息...")
    private String msg;

    @ApiModelProperty(value = "操作人名字", name = "actionName", example = "张三")
    private String actionName;

    @ApiModelProperty(value = "操作信息", name = "actionMsg", example = "张三发布了任务")
    private String actionMsg;
}
