package com.zjty.tynotes.job.status.service.impl;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;
import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.repository.ScoreCoefficientRepository;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.job.status.entity.ActionHistory;
import com.zjty.tynotes.job.status.entity.NoteResource;
import com.zjty.tynotes.job.status.repository.ActionHistoryRepository;
import com.zjty.tynotes.job.status.service.BusinessTreeManagement;
import com.zjty.tynotes.job.status.service.TestService;
import com.zjty.tynotes.pas.service.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2019-05-13
 */
@Service
@Slf4j
public class BusinessTreeManagementImpl implements BusinessTreeManagement {

    @Autowired
    private WorkService workService;

    @Autowired
    private TestService testService;

    @Autowired
    private IUserService iUserService;

    @Autowired
    ScoreCoefficientRepository scoreCoefficientRepository;

    @Autowired
    private ActionHistoryRepository actionHistoryRepository;

    @Override
    public void saveAction(String id, String taskId, int action, Date date, String msg) {
        log.info("[TREE] 获取action，参数为id：{}，taskID：{}，action：{}", id, taskId, action);
        NoteResource noteResource = new NoteResource(id, taskId, action, date);
        dealActionMsg(noteResource, msg);

    }

    @Override
    public void dealActionMsg(NoteResource noteResource, String msg) {
        Work work = workService.findById(noteResource.getTaskId());
        String status = work.getStatus();

        String name = iUserService.findUserById(noteResource.getId()).getUsername();



        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName(name);
        actionHistory.setDate(noteResource.getDate());
        actionHistory.setMsg(msg);
        actionHistory.setTaskId(noteResource.getTaskId());

        //添加任务的发布者上级id集合
        List <String> ids=new ArrayList<>();
        //调用接口获得发布者所有上级id

        List <String> ids1=new ArrayList<>();
        //除了操作人 其他人员的所有id集合
        if (!noteResource.getId().equals(work.getExecutor())){
            ids1.add(work.getExecutor());
        }
        if (!noteResource.getId().equals(work.getPublisher())){
            ids1.add(work.getPublisher());
        }

        for (String id:ids){
            if (!id.equals(noteResource.getId())){
               ids1.add(id);
            }
        }
        int UPDATE_WORKLOAD=8;
//                *               1 -> 发布者发布任务
//                *               2 -> 执行者提交任务
//                *               3 -> 执行者撤回工作
//                *               4 -> 审核审核不通过任务驳回
//                *               5 -> 审核者审核通过
//                *               6 -> 删除工作
//                *               7 -> 修改 任务组员
//                *               8 -> 修改 工作量 以及考评系数
        switch (noteResource.getAction()) {
            case 1:
                if (work.getSuperiorId()==null) {
                    actionHistory.setActionMsg(name + "  新建任务");
                    actionHistoryRepository.save(actionHistory);
                    testService.saveTakePushWork(work.getPublisher(), actionHistory.getActionMsg(), work);
                    log.info("[TREE] {}新建任务", name);
                }else {
                    actionHistory.setActionMsg(name + "  分解任务");
                    actionHistoryRepository.save(actionHistory);
                    testService.saveTakePushWork(work.getPublisher(), actionHistory.getActionMsg(), work);
                    log.info("[TREE] {}新建分解任务，执行人id是{}", name);
                }
                break;

            case 2:

                actionHistory.setActionMsg(name + "  提交任务");
                actionHistoryRepository.save(actionHistory);
                testService.updateWorkStatus(noteResource.getId(),
                                                 actionHistory.getActionMsg(),
                                                 status,
                                                 work);
                log.info("[TREE] {}提交了任务", name);
                break;

            case 3:

                actionHistory.setActionMsg(name + "  撤回任务");
                actionHistoryRepository.save(actionHistory);
                testService.updateWorkStatus(noteResource.getId(),
                        actionHistory.getActionMsg(),
                        status,
                        work);
                log.info("[TREE] {}测绘了任务", name);
                break;

            case 4:

                actionHistory.setActionMsg(name + "  审核任务不通过");
                actionHistoryRepository.save(actionHistory);
                testService.updateWorkStatus(noteResource.getId(),
                        actionHistory.getActionMsg(),
                        status,
                        work);
                log.info("[TREE] {}审核任务不通过", name);
                break;

            case 5:

                actionHistory.setActionMsg(name + "  审核任务通过");
                actionHistoryRepository.save(actionHistory);
                testService.updateWorkStatus(noteResource.getId(),
                        actionHistory.getActionMsg(),
                        status,
                        work);
                log.info("[TREE] {}审核任务通过", name);
                break;

            case 6:


                actionHistory.setActionMsg(name + "  删除任务");
                actionHistoryRepository.save(actionHistory);
                testService.updateWorkStatus(noteResource.getId(),
                        actionHistory.getActionMsg(),
                        status,
                        work);
                log.info("[TREE] {}删除任务", name);
                break;

            case 7:
                actionHistory.setActionMsg(name + " 修改任务");
                actionHistoryRepository.save(actionHistory);
                testService.upDateWork(noteResource.getId(),
                        actionHistory.getActionMsg(),
                        work);
                log.info("[TREE] {}修改了任务的组员", name);
                break;
            case 8:
                actionHistory.setActionMsg(name + " 修改任务");
                actionHistoryRepository.save(actionHistory);
                testService.upDateWork(noteResource.getId(),
                        actionHistory.getActionMsg(),
                        work);
                log.info("[TREE] {}修改了任务的工作量和考评系数", name);
                break;

            case 9:
               String actionMsg = name +"  "+msg;

                actionHistory.setActionMsg(actionMsg);
                actionHistoryRepository.save(actionHistory);
                int count=1;
                switch (msg){
                    case  "自我评价":
                        break;
                    case  "组长评价":
                        count=2;
                        break;
                    case  "总监评价":
                        count=3;
                        break;
                    case  "副总经理评价":
                        count=4;
                        break;
                    case  "总经理评价":
                        count=5;
                        break;
                    case  "修改评价":
                        count=6;
                        break;
                }
                testService.appraisal(noteResource.getId(),actionMsg,work,count);
                log.info("[TREE] {}对任务评价了", name);
                break;

            case 10:
                //保存任务
                actionHistory.setActionMsg(name + "  保存任务");
                actionHistoryRepository.save(actionHistory);
                testService.saveWork(work.getPublisher(),actionHistory.getActionMsg(),work);
                log.info("[TREE] {}保存任务", name);
                break;
            case 11:
                actionHistory.setActionMsg(name + "  发布任务");
                actionHistoryRepository.save(actionHistory);
                testService.unpublishedToOngoing(work.getPublisher(), actionHistory.getActionMsg(), work);
                log.info("[TREE] {}修改任务从未发布到进行中", name);
                break;
            case 12:
                actionHistory.setActionMsg(name + "  完结任务");
                actionHistoryRepository.save(actionHistory);
                testService.updateWorkStatus(noteResource.getId(),
                        actionHistory.getActionMsg(),
                        status,
                       work);
            default:
                log.warn("[es] 状态处理模块传入参数有误");
                break;
        }
    }
}
