package com.zjty.tynotes.pas.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * @Author gwj
 * @create 2020/3/1 10:33
 * @des 节假日配置类
 */
@Document(collection = "pas_day")
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "节假日配置", description = "节假日配置说明")
public class Day {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotEmpty(message = "节假日日期")
    @ApiModelProperty(value = "节假日日期",example = "2020/2/1")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date date;

    @ApiModelProperty(value = "节假日描述,为工作日还是休息日还是团建,默认0为工作日，1为休息日,2为团建",example = "0")
    private String status;

}
