package com.zjty.tynotes.pas.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/2/24 10:50
 * @des 角色类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "角色", description = "角色说明")
@Document(collection = "pas_role")
public class Role {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotNull(message = "角色名称不可为空")
    @ApiModelProperty(value = "角色名称",example = "1")
    private String name;

    @ApiModelProperty(value = "角色描述",example = "1")
    private String description;

    @ApiModelProperty(value = "部门id",example = "1")
    private String departmentId;

    @ApiModelProperty(value = "是否领导",example = "1")
    private String isLeader;//0代表是该部门领导，1代表为该部门普通员工

    @ApiModelProperty(value = "正副经理0为正，1为副",example = "1")
    private String isPlus;//0代表是总经理，1代表为该副经理

    @Transient
    @ApiModelProperty(value = "权限列表")
    List<Authority> authorities;

}
