package com.zjty.tynotes.weekly.subject.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

/**
 * @Author gwj
 * @create 2020/3/30 9:13
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "问题", description = "问题")
@Document(collection = "problem")
public class Problem {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @ApiModelProperty(value = "描述",example = "1")
    private String des;

    @ApiModelProperty(value = "用户id",example = "1")
    private String userId;

    @ApiModelProperty(value = "用户名",example = "")
    private String name;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "反馈时间",example = "")
    private Date submitTime;
}
