package com.zjty.tynotes.attendance.dao;

import com.zjty.tynotes.attendance.entity.AttendanceDetails;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/24 14:55
 */
public interface AttendanceDetailsDao extends MongoRepository<AttendanceDetails,String> {
    AttendanceDetails findByUserId(String userId);

    AttendanceDetails findByUserIdAndAttenDate(String userId,Date date);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetween(String userId,Date startDate,Date endDate);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetweenAndIsThingLeaveDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetweenAndIsSickLeaveDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetweenAndIsLateDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetweenAndIsLeaveEarlyDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetweenAndIsOutSideBusinessDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetweenAndIsOutWorkDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetweenAndIsAbsenteeismDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndAttenDateBetweenAndIsPaidLeaveDay(String userId,Date startDate,Date endDate,String type);
}
