package com.zjty.tynotes.job.status.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author gwj
 * @create 2020/4/10 13:41
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "返给人员模块的数据协议类", description = "人员的任务信息")
public class UserWorkData {

    @ApiModelProperty(value = "人员id", example = "qwer1234")
    private String userId;

    @ApiModelProperty(value = "任务平均分", example = "70")
    private Double averageScore;

    @ApiModelProperty(value = "已完成任务个数", example = "3")
    private Integer completedNum;

    @ApiModelProperty(value = "进行中任务个数", example = "2")
    private Integer unCompletedNum;

    @ApiModelProperty(value = "任务平均工作量数", example = "2")
    private Double averageWorkNum;

}
