package com.zjty.tynotes.job.basic.service;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.entity.response.WorkIsNotCommit;
import com.zjty.tynotes.job.basic.entity.response.WorkMpping;
import com.zjty.tynotes.job.basic.service.impl.WorkServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 9:54
 * <p>@author : C
 * 实现类见↓
 *
 * @see WorkServiceImpl
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Service
public interface WorkService {

    /**
     * 新增工作
     * 不可附带id
     * 判断上级任务id是否存在，存在者减去这次任务设置的分数
     * @param work Work对象
     * @return 新增对象的id
     */
    String add(Work work);

    /**
     * 修改工作
     * 必须附带id
     *
     * @param work Work对象
     * @return 更新对象的id
     */
    String modify(Work work);

    /**
     * 指定id的Work是否存在
     *
     * @param workId 指定id
     * @return 是否存在
     */
    Boolean idExists(String workId);

    /**
     * 查询所有工作
     *
     * @return 对象集合
     */
    List<Work> findAll();

    /**
     * 根据id集合查询所有
     *
     * @param ids id集合
     * @return 对象集合
     */
    List<Work> findAll(List<String> ids);

    /**
     * 查找指定id的Work
     *
     * @param workId 指定id
     * @return Work对象
     */
    Work findById(String workId);

    /**
     * 根据id删除
     *
     * @param id 指定id
     */
    void delete(String id);

    /**
     * 删除所有数据
     */
    void deleteAll();

    /**
     * 修改任务的状态
     * @param taskId 任务id
     * @param status 要修改的状态
     */
    void alterTaskStatus(String taskId, String status,String userId);


    /**
     * 撤回任务的状态
     * @param taskId 任务id
     * @param status 要修改的状态
     */
    void alterTaskStatus1(String taskId, String status,String userId);

    /**
     * 逻辑删除任务
     * @param taskId 任务id
     * @param personalWorkload 是否记录个人工作量 默认记录1 0 为不记录
     * @param  workloadCount 是否记录任务总工作量
     */
    void deleteWork(String taskId, int personalWorkload, int workloadCount);

    /**
     * 修改任务 组员
     * @param taskId 任务id
     *
     * @param crews 组员名单
     */

    void updateWorkCrew(String taskId, List<String> crews, Integer workload);

    /**
     * 修改任务 组员
     * @param taskId 任务id
     *
     * @param workload 工作量
     * @param workCoefficient 考评系数 只能修改0.1-0.2
     */
    void updateWorkload(String taskId, int workload, float workCoefficient);


    /**
     * 根据任务id 查看任务是否有无子任务，子任务是否有未完成
     */
    WorkIsNotCommit findBySuperoirId(String SuperoirId);

    /**
     * 根据任务id 查看任务剩余工作量
     */
    int findBySuperoirIdCount(String SuperoirId);



//    /**
//     * 查看正在进行中的任务
//     */
//    List<Work> selectTimeWork();

    /**
     * 根据用户id查看其部门所有的任务
     * @param userId 用户id
     * @return 返回所有任务
     */
     List<WorkMpping> selectUserIdsWork(String userId);




}
