package com.zjty.tynotes.job.basic.repository;

import com.zjty.tynotes.job.basic.entity.database.Work;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 9:45
 * <p>@author : C
 */
@Repository
public interface WorkRepository extends MongoRepository<Work, String> {
    /**
     *   上级任务id查询所有子任务
     * @param superiorId 任务id
     * @return 任务集合
     */
    List<Work> findBySuperiorId(String superiorId);

    /**
     * 根据执行者id查询所有的任务
     * @param ids 用户id集合
     * @return
     */
    List<Work> findAllByExecutorIn(List<String> ids);

}
