package com.zjty.tynotes.job.status.service.impl;

import com.zjty.tynotes.job.common.Constants;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.common.exception.WorkAttribution;
import com.zjty.tynotes.job.common.exception.WorkAttribution1;
import com.zjty.tynotes.job.status.entity.Personnel;
import com.zjty.tynotes.job.status.entity.RedisPersonalWork;
import com.zjty.tynotes.job.status.service.InternalService;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.search.subject.service.EsUtil;
import com.zjty.tynotes.sms.service.MessageTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
@Service
public class InternalServiceImpl implements InternalService {

    @Autowired
    private RedisTemplate<String,Object> redisTemplate;

    @Autowired
    IUserService iUserService;
    @Override
    public List<Personnel> personnels(List<String> list) {
        List<Personnel> personnels=new ArrayList<>();
        for (String id:list) {
            List<Object> lists = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
            int count=0;
            for (Object object:lists){

                RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
                if (redisPersonalWork.getWorkAttribution()==WorkAttribution1.ME_RECEIVE_WORK && redisPersonalWork.getStatus().equals(WorkStatus.ONGOING)){
                    count++;
                }
                if (redisPersonalWork.getExecutorEqualRelease()==1&& redisPersonalWork.getStatus().equals(WorkStatus.ONGOING)){
                    count++;
                }
            }
            personnels.add(new Personnel(id,iUserService.findUserById(id).getUsername(),count));
        }
        return personnels;
    }

    @Override
    public int personnelWorkCount(String id) {
        List<Object> lists = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
        int count=0;
        for (Object object:lists){

            RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
            if (redisPersonalWork.getWorkAttribution()==WorkAttribution1.ME_RECEIVE_WORK && redisPersonalWork.getStatus().equals(WorkStatus.ONGOING)){
                count++;
            }
            if (redisPersonalWork.getExecutorEqualRelease()==1&& redisPersonalWork.getStatus().equals(WorkStatus.ONGOING)){
                count++;
            }
        }

        return count;
    }
}
