package com.zjty.tynotes.job.task;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.service.ScoreCoefficientService;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.job.common.Action;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.status.service.BusinessTreeManagement;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;

@Slf4j
@Service
public class Task {
    @Autowired
    ScoreCoefficientService scoreCoefficientService;
    @Autowired
    WorkService workService;
    @Autowired
    BusinessTreeManagement businessTreeManagement;

    @Scheduled(cron ="0 0 0 * * ?")
    public void task() {

        long time=LocalDateTime.now().minusDays(7)
                .withHour(0)
                .withMinute(0)
                .withSecond(0)
                .withNano(0)
                .atOffset(ZoneOffset.ofHours(8))
                .toEpochSecond();

        scoreCoefficientService.selectSorct2IsNull()
                               .forEach(
                                       sc->{
                                          Work work= workService.findById(sc.getWordId());
                                          if (work.getAuditTime().getTime()<time){
                                              sc.setScore2(sc.getScore1());
                                              scoreCoefficientService.modify(sc);
                                              businessTreeManagement.saveAction(work.getPublisher(),sc.getWordId(),Action.APPRAISAL_WORD,new Date(),"");

                                              workService.alterTaskStatus(sc.getWordId(),WorkStatus.FINISHED,work.getPublisher());
                                              businessTreeManagement.saveAction(work.getPublisher(), sc.getWordId(), Action.FINISHED_WORK, new Date(), "");
                                          }

                                       }
                               );
    }
}
