package com.zjty.tynotes.attendance.controller;

import com.zjty.tynotes.attendance.entity.ApprovalInformation;
import com.zjty.tynotes.attendance.service.ApprovalInformationService;
import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/24 15:35
 * 审批流程视图层
 */
@Api(tags = "考勤模块", protocols = "http")
@RestController
@RequestMapping("/attendance/approval")
@AutoDocument
public class ApprovalController {
    private static final Logger logger = LoggerFactory.getLogger(ApprovalController.class);

    @Autowired
    private ApprovalInformationService approvalInformationService;

    @ApiOperation(value = "提交审批", response = ApprovalInformation.class)
    @PostMapping("/submit")
    public ResponseEntity addUser(@RequestBody ApprovalInformation approvalInformation) {
        ApprovalInformation approvalInformation1 = approvalInformationService.addApproval(approvalInformation);
        if(approvalInformation1!=null){
            return ok(approvalInformation1);
        }
        return ok("提交审批失败，是否可有加班时长");
    }

    @ApiOperation(value = "删除审批")
    @DeleteMapping("/delete/{id}")
    public ResponseEntity delete(@PathVariable("id") String id) {
        try {
            boolean b = approvalInformationService.deleteApproval(id);
            if(b){
                return ok("删除审批成功");
            }
        } catch (Exception e) {
            logger.error("删除审批失败");
        }
        return ok("删除审批失败");
    }

    /**
     * userId为审核者id,id为审批id,approvalStatus为该审批者是否接受审批
     * @param userId
     * @param approvalInformation
     * @param approvalStatus
     * @return
     */
    @ApiOperation(value = "审核审批")
    @PostMapping("/audit/{userId}/{approvalStatus}")
    public ResponseEntity audit(@PathVariable String userId,@PathVariable String approvalStatus,
                                @RequestBody ApprovalInformation approvalInformation) {
        try {
            ApprovalInformation approvalInformation1 = approvalInformationService.auditApproval(userId,approvalStatus,approvalInformation);
            return ok(approvalInformation1);
        } catch (Exception e) {
            logger.error("审核审批失败");
        }
        return ok("审核审批失败");
    }


    @ApiOperation(value = "查找所有我提交的审批")
    @GetMapping("findAllSubmitApproval/{userId}")
    public ResponseEntity findAllSubmitApproval(@PathVariable String userId) {
        try {
            List<ApprovalInformation> approvalInformations = approvalInformationService.findAllApproval(userId);
            return ok(approvalInformations);
        } catch (Exception e) {
            logger.error("查找自身提交的审批失败");
        }
        return ok("查找自身提交的审批失败");
    }

    @ApiOperation(value = "查找所有我审核的审批")
    @GetMapping("/findAllAuditApproval/{userId}")
    public ResponseEntity findAllAuditApproval(@PathVariable String userId) {
        try {
            List<ApprovalInformation> approvalInformations = approvalInformationService.findAllAuditApproval(userId);
            return ok(approvalInformations);
        } catch (Exception e) {
            logger.error("查找所有我审核的审批");
        }
        return ok("查找所有我审核的审批");
    }


}
