package com.zjty.tynotes.job.basic.service.impl;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;
import com.zjty.tynotes.job.basic.repository.ScoreCoefficientRepository;
import com.zjty.tynotes.job.basic.service.ScoreCoefficientService;
import com.zjty.tynotes.job.common.exception.BadRequestException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;

import static java.util.Objects.isNull;
import static java.util.Objects.nonNull;

@Service
@Slf4j
public class ScoreCoefficientServiceImpl implements ScoreCoefficientService {
    private final
    ScoreCoefficientRepository scoreCoefficientRepository;

    @Autowired
    public ScoreCoefficientServiceImpl(ScoreCoefficientRepository scoreCoefficientRepository) {
        this.scoreCoefficientRepository = scoreCoefficientRepository;
    }

    @Override
    public String add(ScoreCoefficient scoreCoefficient) {
        Boolean idIsNull=isNull(scoreCoefficient.getId());
        if (idIsNull){
           String id=scoreCoefficientRepository.save(scoreCoefficient).getId();
           log.info("[job] 任务{},考评添加成功,id为 {} ",scoreCoefficient.getWordId(),id);
           return id;
        }else {
            String msg="[job] 任务"+scoreCoefficient.getWordId()+",新增考评数据不能带id.";
            log.error(msg);
            throw new BadRequestException(msg);
        }
    }

    @Override
    public String modify(ScoreCoefficient scoreCoefficient) {
        Boolean idMustExist = (nonNull(scoreCoefficient.getId())) && (scoreCoefficientRepository.existsById(scoreCoefficient.getId()));
        if (idMustExist) {
            String modifyId = scoreCoefficientRepository.save(scoreCoefficient).getId();
            log.info(String.format("[job] 更新了任务id为 %s 的考评数据id为 %s .", scoreCoefficient.getWordId(),modifyId));
            return modifyId;
        } else {
            String msg = "[job] 更新数据必须指定id且指定id的数据存在.";
            log.error(msg);
            throw new BadRequestException(msg);
        }
    }

    @Override
    public Boolean idExists(String Id) {
        return scoreCoefficientRepository.existsById(Id);
    }

    @Override
    public ScoreCoefficient findById(String id) {
        Optional<ScoreCoefficient> scoreOptional = scoreCoefficientRepository.findById(id);
        return scoreOptional.orElseThrow(() -> new BadRequestException(String.format("[job] 考评id为 %s 的数据不存在.", id)));
    }
}
