package com.zjty.tynotes.job.basic.entity.request;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>Description : ty-note-backend
 * <p>Date : 2019/5/13 15:53
 * <p>@author : C
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "工作RO", description = "工作记录模块的请求数据对象")
public class WorkRo {
    /**
     * 当前用户id
     */
    @ApiModelProperty(value = "当前用户id", example = "id")
    private String userId;

    /**
     * 备注信息
     */
    @ApiModelProperty(value = "备注信息", example = "some remarks")
    private String remarks;

    /**
     * 工作对象
     */
    @ApiModelProperty(value = "工作对象")
    private Work work;
}
