package com.zjty.tynotes.pas.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotNull;
import java.util.List;


/**
 * @author mcj
 */
@Document(collection = "pas_department")
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "部门", description = "部门说明")
public class Department {
    @ApiModelProperty(value = "id")
    @Id
    String id;
    @ApiModelProperty(value = "部门名称",example = "xx部门")
    @NotNull(message = "部门名称不可为空")
    String name;
    @ApiModelProperty(value = "部门等级",example = "1")
    @NotNull(message = "部门等级不可为空")
    String level;

    @ApiModelProperty(value = "部门描述",example = "1")
    String description;

    @ApiModelProperty(value = "上级部门id",example = "1")
    String parentId;

    @Transient
    private List<User> users;

    @Transient
    private List<Department> departments;
}
