package com.zjty.tynotes.job.status.service;

import com.zjty.tynotes.job.status.entity.NoteResource;

import java.util.Date;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2019-05-13
 */
public interface BusinessTreeManagement {

    /**
     * 任务操作后将记录发送给kafka中
     *
     * @param id     操作人id
     * @param taskId 事件id
     * @param action 操作动作说明，action：   使用Action.方法
     *               1 -> 执行人发布任务
     *               2 -> 执行人提交任务
     *               3 -> 审核人退回已提交任务
     *               4 -> 审核人完结任务
     *               5 -> 修改审核人
     *               6 -> 修改关注人
     *               7 -> 对事件留言
     * @param date   操作时间
     * @param msg    备注内容
     */
    void saveAction(String id, String taskId, int action, Date date, String msg);

    /**
     * 根据不同的操作保存数据
     *
     * @param noteResource 传入对象
     * @param msg 备注信息
     */
    void dealActionMsg(NoteResource noteResource, String msg);

}
