/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.schedule;

import com.taobao.api.internal.toplink.LoggerFactory;
import com.taobao.api.internal.toplink.schedule.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchedScheduler<T>
extends Scheduler<T> {
    private List<Runnable> batched = new ArrayList<Runnable>();

    public BatchedScheduler() {
    }

    public BatchedScheduler(LoggerFactory loggerFactory) {
        super(loggerFactory);
    }

    @Override
    protected Runnable poll(Queue<Runnable> queue) {
        Runnable first = queue.poll();
        if (first == null) {
            return null;
        }
        if (!this.enableBatch(first)) {
            return first;
        }
        this.batched.add(first);
        int i = this.getBatchSize(first);
        while (i-- > 0 && this.areInSameBatch(queue.peek(), first)) {
            this.batched.add(queue.poll());
        }
        if (this.batched.size() == 1) {
            return this.batched.get(0);
        }
        final Object[] tasks = this.batched.toArray();
        this.batched.clear();
        Runnable batchedTask = new Runnable(){

            public void run() {
                for (Object t : tasks) {
                    try {
                        ((Runnable)t).run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        return batchedTask;
    }

    protected boolean enableBatch(Runnable task) {
        return true;
    }

    protected int getBatchSize(Runnable task) {
        return 10;
    }

    protected boolean areInSameBatch(Runnable next, Runnable first) {
        return next != null && first.getClass().equals(next.getClass());
    }
}

