package com.zjty.tynotes.job.basic.entity.database;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * <p>Description : tynotes
 * <p>Date : 2019/4/22 14:58
 * <p>@author : C
 * 工作记录
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "工作", description = "工作对象")
public class Work {
    /**
     * id
     */
    @Id
    @ApiModelProperty(value = "id.若新增数据则不可附带id.更新已有数据则必须附带id.", example = "id", notes = "若新增数据则不可附带id.更新已有数据则必须附带id")
    private String id;
    /**
     * 标题
     */
    @NotNull
    @ApiModelProperty(value = "标题", example = "请输入标题")
    private String title;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
     * 预计完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "预计完成时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date completeTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "更新时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    /*相关用户 同一个人不能同时担任多种职位*/
    /**
     * 发布者id
     */
    @NotNull
    @ApiModelProperty(value = "发布者的用户id.", example = "id")
    private String publisher;
    /**
     * 执行者id
     */
    @NotNull
    @ApiModelProperty(value = "执行者的用户id.", example = "id")
    private String executor;
    /**
     * 审核者id集合
     */
    @NotNull
    @ApiModelProperty(value = "审核者的用户id集合.", example = "[\"id\",\"id\"]")
    private List<String> checker;
    /**
     * 关注者id集合
     */
    @NotNull
    @ApiModelProperty(value = "关注者的用户id集合.", example = "[\"id\",\"id\"]")
    private List<String> follower;

    /**
     * 附件id
     */
    @NotNull
    @ApiModelProperty(value = "附件的id集合.", example = "[\"id\",\"id\"]")
    private List<String> attachment;

    /**
     * 留言id
     */
    @NotNull
    @ApiModelProperty(value = "留言的id集合.", example = "[\"id\",\"id\"]")
    private List<String> comment;

    /*工作内容*/
    /**
     * 内容
     * 内容字数有上限3000个字，上限可设置。
     */
    @NotNull
    @ApiModelProperty(value = "内容", example = "内容...............", notes = "内容字数有上限3000个字，上限可设置.")
    private String content;

    /**
     * 是否为正式的
     * 正式的是在工作簿页面上显示的
     * 非正式的是不在工作簿页面上显示的 目前就是草稿
     * <p>
     * 申请任务时只能指定审核者和关注者
     * 申请的任务转正后发布者为审核者 执行者为申请者
     */
    @NotNull
    @ApiModelProperty(value = "是否为正式的.正式的是在工作簿页面上显示的.非正式的目前就是草稿.", example = "true")
    private Boolean isFormal;

    /**
     * 工作状态
     * 目前有：进行中、已提交、已完结
     */
    @NotEmpty
    @NotNull
    @ApiModelProperty(value = "状态.进行中:underway、已提交:committed、已完结:finished", example = "finished")
    private String status;

}
