package com.zjty.tynotes.job.basic.entity.response;

import com.zjty.tynotes.job.basic.entity.database.Attachment;
import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.job.basic.entity.database.Comment;
import com.zjty.tynotes.pas.entity.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 11:21
 * <p>@author : C
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "工作VO", description = "工作记录模块的返回数据对象")
public class WorkVo {
    /**
     * id
     */
    @ApiModelProperty(value = "id", example = "id")
    private String id;
    /**
     * 标题
     */
    @ApiModelProperty(value = "标题", example = "请输入标题")
    private String title;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 预计完成时间
     */
    @ApiModelProperty(value = "预计完成时间")
    private Date completeTime;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /*相关用户 同一个人不能同时担任多种职位*/
    /**
     * 发布者
     *
     * @see User
     */
    @ApiModelProperty(value = "发布者")
    private User publisher;
    /**
     * 执行者
     *
     * @see User
     */
    @ApiModelProperty(value = "执行者")
    private User executor;
    /**
     * 审核者
     *
     * @see User
     */
    @ApiModelProperty(value = "审核者")
    private List<User> checker;
    /**
     * 关注者
     *
     * @see User
     */
    @ApiModelProperty(value = "关注者")
    private List<User> follower;

    /**
     * 附件
     * 该任务中的附件
     * 分3种类型：初始附件、工作附件、交流附件
     * 由Attachment类中的type属性区分附件类型
     *
     * @see Attachment
     */
    @ApiModelProperty(value = "附件.该任务中的附件，分3种类型：初始附件、工作附件、交流附件，由Attachment模型中的type属性区分附件类型.")
    private List<Attachment> attachment;

    /**
     * 留言
     *
     * @see CommentVo
     */
    @ApiModelProperty(value = "留言")
    private List<CommentVo> comment;

    /*工作内容*/
    /**
     * 内容
     * 内容字数有上限3000个字，上限可设置。
     */
    @ApiModelProperty(value = "内容", example = "若是内容过多，将显示滚动条，同时，内容字数有上限3000个字，上限可设置，若是内容超出，请附件。")
    private String content;
    /**
     * 是否为正式的
     * 正式的是在工作簿页面上显示的
     * 非正式的是不在工作簿页面上显示的 目前就是草稿
     * <p>
     * 申请任务时只能指定审核者和关注者
     * 申请的任务转正后发布者为审核者 执行者为申请者
     */
    @ApiModelProperty(value = "是否为正式.正式的是在工作簿页面上显示的;非正式的是草稿.", example = "true", notes = "正式的是在工作簿页面上显示的;非正式的是草稿")
    private Boolean isFormal;

    /**
     * Job状态
     * 目前有：进行中、已提交、已完结
     */
    @ApiModelProperty(value = "状态.进行中:underway、已提交:committed、已完结:finished.", example = "finished")
    private String status;

}
